<?php
/**
 * FlareHub API Router
 * Main entry point for all API requests
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Response.php';
require_once __DIR__ . '/classes/RateLimiter.php';
require_once __DIR__ . '/classes/JWT.php';
require_once __DIR__ . '/classes/Auth.php';

// Initialize rate limiter
$rateLimiter = new RateLimiter();
$ipAddress = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
$endpoint = $_SERVER['REQUEST_URI'] ?? '/';

// Check rate limit
if (!$rateLimiter->checkLimit($ipAddress, $endpoint)) {
    Response::rateLimitExceeded();
}

// Get request method and URI
$method = $_SERVER['REQUEST_METHOD'];
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = str_replace('/api/' . API_VERSION, '', $uri);

// Remove trailing slash
$uri = rtrim($uri, '/');

// Route the request
try {
    switch ($uri) {
        // Authentication routes
        case '/auth/register':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/auth/register.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/auth/login':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/auth/login.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/auth/logout':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/auth/logout.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/auth/wallet/connect':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/auth/connect-wallet.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/wallet/verify':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/wallet/verify.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/wallet/verification-status':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/wallet/verification-status.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/user/update-profile':
            if ($method === 'PUT') {
                require_once __DIR__ . '/endpoints/user/update-profile.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Dashboard routes
        case '/dashboard/overview':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/dashboard/overview.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/dashboard/portfolio':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/dashboard/portfolio.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Farm routes
        case '/farms':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/farms/list.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/farms/stake':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/farms/stake.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/farms/unstake':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/farms/unstake.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/farms/harvest':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/farms/harvest.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Staking routes
        case '/staking/pools':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/staking/pools.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/staking/stake':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/staking/stake.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/staking/unstake':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/staking/unstake.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/staking/claim':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/staking/claim.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Swap routes
        case '/swap/quote':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/swap/quote.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/swap/execute':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/swap/execute.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Bridge routes
        case '/bridge/estimate':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/bridge/estimate.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/bridge/execute':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/bridge/execute.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Governance routes
        case '/governance/proposals':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/governance/proposals.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/governance/vote':
            if ($method === 'POST') {
                require_once __DIR__ . '/endpoints/governance/vote.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Wallet routes
        case '/wallet/balance':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/wallet/balance.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        case '/wallet/transactions':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/wallet/transactions.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        // Health check
        case '/health':
            if ($method === 'GET') {
                Response::success([
                    'status' => 'healthy',
                    'version' => API_VERSION,
                    'timestamp' => date('c')
                ]);
            } else {
                Response::methodNotAllowed();
            }
            break;

        // API documentation
        case '/docs':
            if ($method === 'GET') {
                require_once __DIR__ . '/endpoints/docs.php';
            } else {
                Response::methodNotAllowed();
            }
            break;

        default:
            Response::notFound('Endpoint not found');
            break;
    }

} catch (Exception $e) {
    error_log("API Error: " . $e->getMessage());
    Response::internalError('An unexpected error occurred');
}
?>
