<?php
/**
 * Farms List Endpoint
 * GET /api/v1/farms
 */

require_once __DIR__ . '/../../classes/Farms.php';

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

try {
    $farms = new Farms();
    $farmList = $farms->getFarmPools($payload['user_id']);

    Response::success($farmList, 'Farm pools retrieved successfully');

} catch (Exception $e) {
    error_log("Farms list error: " . $e->getMessage());
    Response::internalError('Failed to retrieve farm pools');
}
?>
