<?php
/**
 * Farm Harvest Endpoint
 * POST /api/v1/farms/harvest
 */

require_once __DIR__ . '/../../classes/Farms.php';

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || !isset($input['wallet_id']) || !isset($input['farm_pool_id'])) {
    Response::validationError([
        'wallet_id' => 'Wallet ID is required',
        'farm_pool_id' => 'Farm pool ID is required'
    ]);
}

$walletId = (int)$input['wallet_id'];
$farmPoolId = (int)$input['farm_pool_id'];

try {
    $farms = new Farms();
    $result = $farms->harvest($payload['user_id'], $walletId, $farmPoolId);

    if ($result['success']) {
        Response::success($result, 'Successfully harvested rewards');
    } else {
        Response::error($result['message'], 400);
    }

} catch (Exception $e) {
    error_log("Farm harvest error: " . $e->getMessage());
    Response::internalError('Failed to harvest rewards');
}
?>
