<?php
/**
 * Portfolio Endpoint
 * GET /api/v1/dashboard/portfolio
 */

require_once __DIR__ . '/../../classes/Dashboard.php';

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

try {
    $dashboard = new Dashboard();
    $portfolio = $dashboard->getPortfolio($payload['user_id']);

    Response::success($portfolio, 'Portfolio retrieved successfully');

} catch (Exception $e) {
    error_log("Portfolio error: " . $e->getMessage());
    Response::internalError('Failed to retrieve portfolio');
}
?>
