<?php
/**
 * Dashboard Overview Endpoint
 * GET /api/v1/dashboard/overview
 */

require_once __DIR__ . '/../../classes/Dashboard.php';

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

try {
    $dashboard = new Dashboard();
    $overview = $dashboard->getOverview($payload['user_id']);

    Response::success($overview, 'Dashboard overview retrieved successfully');

} catch (Exception $e) {
    error_log("Dashboard overview error: " . $e->getMessage());
    Response::internalError('Failed to retrieve dashboard overview');
}
?>
