<?php
/**
 * Application Configuration
 * FlareHub Backend API
 */

// Environment settings
define('ENVIRONMENT', 'production'); // Change to 'development' for local testing
define('API_VERSION', 'v1');
define('BASE_URL', 'https://flarehub.net/api/' . API_VERSION);

// JWT Configuration
define('JWT_SECRET', '43PV949ETPGR43RNQSAIGQFQKMHPV949ETPGYDC4BQFQKMH3B3TVYDC4B');
define('JWT_ALGORITHM', 'HS256');
define('JWT_EXPIRY', 3600 * 24 * 7); // 7 days

// CORS Configuration
define('ALLOWED_ORIGINS', [
    'https://flarehub.net',
    'https://www.flarehub.net',
    'https://flarehub-mu.vercel.app',
    'http://localhost:3000' // For development
]);

// Rate Limiting
define('RATE_LIMIT_REQUESTS', 100);
define('RATE_LIMIT_WINDOW', 3600); // 1 hour

// Security
define('ENCRYPTION_KEY', '49ETPGR43RNQSAIGQFQKMHPV949ETPGYDC4BQFQKMH3B3TVYD');
define('HASH_ALGORITHM', 'sha256');

// Blockchain Configuration - Using Etherscan Multichain API
define('ETHERSCAN_API_KEY', '43PV949ETPGRNQSAIGQFQKMH3B3TVYDC4B');
define('ETHERSCAN_API_BASE_URL', 'https://api.etherscan.io/v2/api');

// Supported Chain IDs for Etherscan Multichain API
define('SUPPORTED_CHAINS', [
    1 => 'ethereum',      // Ethereum Mainnet
    137 => 'polygon',     // Polygon
    56 => 'bsc',          // BSC
    42161 => 'arbitrum',  // Arbitrum One
    10 => 'optimism',     // Optimism
    250 => 'fantom',      // Fantom
    43114 => 'avalanche', // Avalanche
    25 => 'cronos',       // Cronos
    1284 => 'moonbeam',   // Moonbeam
    1285 => 'moonriver',  // Moonriver
    100 => 'gnosis',      // Gnosis Chain
    1666600000 => 'harmony', // Harmony
    128 => 'heco',        // Huobi ECO Chain
    66 => 'okex',         // OKExChain
    1287 => 'moonbase',   // Moonbase Alpha
    97 => 'bsc-testnet',  // BSC Testnet
    5 => 'goerli',        // Goerli Testnet
    11155111 => 'sepolia' // Sepolia Testnet
]);

// Fallback RPC URLs (for operations not supported by Etherscan API)
define('FALLBACK_RPC_URLS', [
    1 => 'https://mainnet.infura.io/v3/d6f17c331c994254a5a2751a14ff1351',
    137 => 'https://polygon-rpc.com',
    56 => 'https://bsc-dataseed.binance.org',
    42161 => 'https://arb1.arbitrum.io/rpc',
    10 => 'https://mainnet.optimism.io',
    250 => 'https://rpc.ftm.tools',
    43114 => 'https://api.avax.network/ext/bc/C/rpc'
]);

// External API Keys
define('COINGECKO_API_KEY', 'CG-c43PV949ETPGRNQSAIGQFQKMH3B3TVYDC4BcJ7gNm');

// Error Reporting
if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set('UTC');

// Headers
header('Content-Type: application/json; charset=utf-8');
header('X-API-Version: ' . API_VERSION);
header('X-Powered-By: FlareHub API');

// CORS Headers
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
if (in_array($origin, ALLOWED_ORIGINS)) {
    header('Access-Control-Allow-Origin: ' . $origin);
}
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Access-Control-Max-Age: 86400');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>
