<?php
/**
 * Wallet Verification Status Endpoint
 * GET /api/v1/wallet/verification-status
 */

require_once __DIR__ . '/../../classes/WalletVerification.php';

// Get wallet address from query parameters
$walletAddress = $_GET['wallet_address'] ?? '';

if (empty($walletAddress)) {
    Response::validationError(['wallet_address' => 'Wallet address is required']);
}

// Validate wallet address format
if (!preg_match('/^0x[a-fA-F0-9]{40}$/', $walletAddress)) {
    Response::validationError(['wallet_address' => 'Invalid wallet address format']);
}

try {
    $walletVerification = new WalletVerification();
    $result = $walletVerification->checkVerificationStatus($walletAddress);

    if ($result['success']) {
        Response::success($result, 'Verification status retrieved successfully');
    } else {
        Response::error($result['message'], 404);
    }

} catch (Exception $e) {
    error_log("Verification status check error: " . $e->getMessage());
    Response::internalError('Failed to check verification status');
}
?>
