<?php
/**
 * Farm Stake Endpoint
 * POST /api/v1/farms/stake
 */

require_once __DIR__ . '/../../classes/Farms.php';

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || !isset($input['wallet_id']) || !isset($input['farm_pool_id']) || !isset($input['amount'])) {
    Response::validationError([
        'wallet_id' => 'Wallet ID is required',
        'farm_pool_id' => 'Farm pool ID is required',
        'amount' => 'Amount is required'
    ]);
}

$walletId = (int)$input['wallet_id'];
$farmPoolId = (int)$input['farm_pool_id'];
$amount = (float)$input['amount'];

// Validate amount
if ($amount <= 0) {
    Response::validationError(['amount' => 'Amount must be greater than 0']);
}

try {
    $farms = new Farms();
    $result = $farms->stake($payload['user_id'], $walletId, $farmPoolId, $amount);

    if ($result['success']) {
        Response::success($result, 'Successfully staked in farm pool');
    } else {
        Response::error($result['message'], 400);
    }

} catch (Exception $e) {
    error_log("Farm stake error: " . $e->getMessage());
    Response::internalError('Failed to stake in farm pool');
}
?>
