<?php
/**
 * User Registration Endpoint
 * POST /api/v1/auth/register
 */

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || !isset($input['email']) || !isset($input['username']) || !isset($input['password'])) {
    Response::validationError([
        'email' => 'Email is required',
        'username' => 'Username is required',
        'password' => 'Password is required'
    ]);
}

$email = trim($input['email']);
$username = trim($input['username']);
$password = $input['password'];
$firstName = $input['first_name'] ?? null;
$lastName = $input['last_name'] ?? null;

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    Response::validationError(['email' => 'Invalid email format']);
}

// Validate username (3-20 characters, alphanumeric and underscore only)
if (!preg_match('/^[a-zA-Z0-9_]{3,20}$/', $username)) {
    Response::validationError(['username' => 'Username must be 3-20 characters, alphanumeric and underscore only']);
}

// Validate password (minimum 8 characters)
if (strlen($password) < 8) {
    Response::validationError(['password' => 'Password must be at least 8 characters long']);
}

// Validate names if provided
if ($firstName && strlen($firstName) > 100) {
    Response::validationError(['first_name' => 'First name must be less than 100 characters']);
}

if ($lastName && strlen($lastName) > 100) {
    Response::validationError(['last_name' => 'Last name must be less than 100 characters']);
}

// Register user
$auth = new Auth();
$result = $auth->register($email, $username, $password, $firstName, $lastName);

if ($result['success']) {
    Response::success($result, 'User registered successfully', 201);
} else {
    Response::error($result['message'], 400);
}
?>
