<?php
/**
 * User Logout Endpoint
 * POST /api/v1/auth/logout
 */

// Get token from Authorization header
$token = JWT::extractToken();

if (!$token) {
    Response::unauthorized('Token required');
}

// Verify token
$payload = JWT::verify($token);
if (!$payload) {
    Response::unauthorized('Invalid token');
}

// Logout user
$auth = new Auth();
$result = $auth->logout($token);

if ($result['success']) {
    Response::success(null, 'Logged out successfully');
} else {
    Response::error($result['message'], 500);
}
?>
