<?php
/**
 * User Login Endpoint
 * POST /api/v1/auth/login
 */

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || !isset($input['email']) || !isset($input['password'])) {
    Response::validationError([
        'email' => 'Email is required',
        'password' => 'Password is required'
    ]);
}

$email = trim($input['email']);
$password = $input['password'];

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    Response::validationError(['email' => 'Invalid email format']);
}

// Login user
$auth = new Auth();
$result = $auth->login($email, $password);

if ($result['success']) {
    Response::success($result, 'Login successful');
} else {
    Response::error($result['message'], 401);
}
?>
