<?php
/**
 * Connect Wallet Endpoint (Wallet-First Authentication)
 * POST /api/v1/auth/wallet/connect
 */

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!$input || !isset($input['wallet_address']) || !isset($input['wallet_type']) || !isset($input['chain_id'])) {
    Response::validationError([
        'wallet_address' => 'Wallet address is required',
        'wallet_type' => 'Wallet type is required',
        'chain_id' => 'Chain ID is required'
    ]);
}

$walletAddress = trim($input['wallet_address']);
$walletType = $input['wallet_type'];
$chainId = (int)$input['chain_id'];

// Validate wallet address (basic Ethereum address format)
if (!preg_match('/^0x[a-fA-F0-9]{40}$/', $walletAddress)) {
    Response::validationError(['wallet_address' => 'Invalid wallet address format']);
}

// Validate wallet type
$allowedTypes = ['metamask', 'coinbase', 'trust', 'walletconnect', 'other'];
if (!in_array($walletType, $allowedTypes)) {
    Response::validationError(['wallet_type' => 'Invalid wallet type']);
}

// Validate chain ID
$allowedChains = [1, 42161, 137, 56]; // ETH, Arbitrum, Polygon, BSC
if (!in_array($chainId, $allowedChains)) {
    Response::validationError(['chain_id' => 'Unsupported chain ID']);
}

// TODO: Implement signature verification for wallet connection
// For now, we'll accept the connection without signature verification
// In production, you should verify the wallet signature

// Connect wallet (wallet-first authentication)
$auth = new Auth();
$result = $auth->connectWallet($walletAddress, $walletType, $chainId);

if ($result['success']) {
    Response::success($result, 'Wallet connected successfully');
} else if (isset($result['requires_verification']) && $result['requires_verification']) {
    Response::error($result['message'], 403, [
        'requires_verification' => true,
        'wallet_address' => $result['wallet_address'],
        'chain_id' => $result['chain_id'],
        'balance_info' => $result['balance_info']
    ]);
} else {
    Response::error($result['message'], 400);
}
?>
